# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2001,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CRM_cli_include;
#"@(#)90   1.5   src/rsct/rm/ConfigRM/cli/pm/CRM_cli_include.pm.perl, configrmcli, rsct_rzauh, rzauhbase 5/3/02 13:35:50"
######################################################################
#                                                                    #
# Package: CRM_cli_include.pm                                        #
#                                                                    #
# Description:                                                       #
#   This package contains constants that are common for the          #
#   Configuration Resource Manager (ConfigRM) CLI commands.          #
#                                                                    #
#--------------------------------------------------------------------#
# Inputs:                                                            #
#   none.                                                            #
#                                                                    #
# Outputs:                                                           #
#   none.                                                            #
#                                                                    #
# External References:                                               #
#   none.                                                            #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   010806 JAC 75435: Initial design & write.                        #
#   010827 JAC 75436: Add some constants.                            #
#   011130 JAC 77315: Updates for comg commands.                     #
#   020422 JAC 82249: Change cluster resource class.                 #
#   020502 JAC 82564: Add constants for scope.                       #
######################################################################

use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw(
    $TRUE $FALSE $DELIMITER
    $MSGCAT $MSGSET $CTDIR $CTBINDIR $LSMSG
    $RSCLUSTER $RSNODE $RSCOMG $RSNETI
    $RMC_CLI_USER_ERROR $RMC_CLI_RSRC_NOT_FOUND
    $RMC_OPSTATE_ONLINE 
    $LOW_PORT $HIGH_PORT
    $SENSITIVITY_LOW $PERIOD_LOW
    $PRIORITY_LOW
    $BROADCAST $SRCROUTING
    $LOCAL_SCOPE $PEER_DOMAIN_SCOPE
    $RMC_SCOPE_ERROR
);

#use lib "/usr/sbin/rsct/pm";
use locale;

#--------------------------------------------------------------------#
#  The constants for ConfigRM CLI                                    #
#--------------------------------------------------------------------#
$MSGCAT = "configrmcli.cat";           # msg catalog for this cmd
$MSGSET = "configrmcli";               # common message set

$CTDIR = "/usr/sbin/rsct";             # RSCT root directory
$CTBINDIR = "$CTDIR/bin";              # Cluster Bin directory path
$LSMSG = "$CTBINDIR/ctdspmsg";         # list / display message rtn
$ENV{'MSGMAPPATH'} = "$CTDIR/msgmaps"; # msg maps used by $LSMSG

$FALSE = 0;
$TRUE = 1;

#$RSCLUSTER = "IBM.SharedResourceCluster";  # cluster resource
$RSCLUSTER = "IBM.PeerDomain";         # cluster resource
$RSNODE = "IBM.PeerNode";              # node resource
$RSCOMG = "IBM.CommunicationGroup";    # communication group resource
$RSNETI = "IBM.NetworkInterface";      # network interface class

$RMC_CLI_USER_ERROR = 5;               # RMC CLI user error
$RMC_CLI_RSRC_NOT_FOUND = 6;           # RMC CLI resource not found
$LOW_PORT = 1024;                      # lowest port number possible
$HIGH_PORT = 65000;                    # highest port number possible

$SENSITIVITY_LOW = 2;                  # minimum sensitivity for comg
$PERIOD_LOW = 1;                       # minimum period for comg
$PRIORITY_LOW = 1;                     # minimum priority for comg
$BROADCAST = "b";                      # broadcast
$SRCROUTING = "r";                     # source routing

$LOCAL_SCOPE = 1;                      # local scope
$PEER_DOMAIN_SCOPE = 2;                # peer domain scope
$RMC_SCOPE_ERROR = 43;                 # scope not supported

$DELIMITER = "tvtv";                   # a delimiter to use

$RMC_OPSTATE_ONLINE = 1;               # online op state
#/* enumeration of the possible resource state */
#typedef enum {
#    RMC_OPSTATE_UNKNOWN=0,
#    RMC_OPSTATE_ONLINE,
#    RMC_OPSTATE_OFFLINE,
#    RMC_OPSTATE_FAILED_OFFLINE,
#    RMC_OPSTATE_STUCK_ONLINE,
#    RMC_OPSTATE_PENDING_ONLINE,
#    RMC_OPSTATE_PENDING_OFFLINE,
#    RMC_OPSTATE_MIXED,
#    RMF_OPSTATE_MASK=0x7f,
#    RMC_OPSTATE_MANUAL_MODE=0x80,
#    RMC_OPSTATE_ONLINE_MANUAL,
#    RMC_OPSTATE_OFFLINE_MANUAL,
#    RMC_OPSTATE_FAILED_OFFLINE_MANUAL,
#    RMC_OPSTATE_STUCK_ONLINE_MANUAL,
#    RMC_OPSTATE_PENDING_ONLINE_MANUAL,
#    RMC_OPSTATE_PENDING_OFFLINE_MANUAL,
#    RMC_OPSTATE_MIXED_MANUAL
#} rmc_opstate_t;



#--------------------------------------------------------------------#
# End File.                                                          #
#--------------------------------------------------------------------#
